/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.earth;

import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import java.util.HashMap;
import java.util.Map;

public class TreeNodeIdManager {
    private static final String TRACEMASK_T = "XBUITIDT";
    private static final String TRACEMASK_F = "XBUITIDF";
    private static final String TRACEMASK_D = "XBUITIDD";
    private static final Object LOCK = new Object();
    private static final int ID_LENGTH = 8;
    private static final String PADDING = "0000000";
    private static TreeNodeIdManager idManager;
    private Map idToNodeMap = new HashMap();
    private int nextId = 0;

    private TreeNodeIdManager() {
        Trace.trace(TRACEMASK_T, "<> TreeNodeIdManager()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        Trace.trace(TRACEMASK_T, "<--> TreeNodeIdManager.init()");
        Object object = LOCK;
        synchronized (object) {
            if (idManager == null) {
                idManager = new TreeNodeIdManager();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TreeNodeIdManager getTreeNodeIdManager() {
        Object object = LOCK;
        synchronized (object) {
            return idManager;
        }
    }

    public String add(BonsaiTreeNode node) {
        String id = this.getNextId();
        while (this.idToNodeMap.containsKey(id)) {
            id = this.getNextId();
        }
        this.idToNodeMap.put(id, node);
        return id;
    }

    public BonsaiTreeNode getNode(String id) {
        return (BonsaiTreeNode)this.idToNodeMap.get(id);
    }

    public boolean remove(String id) {
        return this.idToNodeMap.remove(id) != null;
    }

    private String getNextId() {
        String id = PADDING + Integer.toHexString(this.nextId++).toUpperCase();
        return id.substring(id.length() - 8);
    }
}

